"""Home/dashboard page showing summary metrics and charts."""

import streamlit as st
import plotly.express as px
from services.report_service import ReportService


def render() -> None:
    st.title("Dashboard")
    report_service = ReportService()

    # Status summary
    status_counts = report_service.status_summary()
    c1, c2, c3, c4 = st.columns(4)
    c1.metric("Pending", status_counts.get("Pending", 0))
    c2.metric("In Progress", status_counts.get("In Progress", 0))
    c3.metric("Completed", status_counts.get("Completed", 0))
    c4.metric("Deferred", status_counts.get("Deferred", 0))

    # Workload chart
    st.subheader("Workload Distribution")
    workload_df = report_service.workload_distribution()
    if workload_df.empty:
        st.info("No assignments yet.")
    else:
        fig = px.bar(workload_df, x="employee", y="tasks_assigned", title=None)
        st.plotly_chart(fig, use_container_width=True)

    # Overdue list
    st.subheader("Overdue Assignments")
    delays_df = report_service.delay_report()  # NOTE: no argument
    if delays_df.empty:
        st.success("No overdue assignments.")
    else:
        st.dataframe(delays_df, use_container_width=True)
